% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_release_series.R
\name{fredr_release_series}
\alias{fredr_release_series}
\title{Get the series on a release of economic data}
\usage{
fredr_release_series(
  release_id,
  ...,
  filter_variable = NULL,
  filter_value = NULL,
  tag_names = NULL,
  exclude_tag_names = NULL,
  limit = NULL,
  offset = NULL,
  order_by = NULL,
  sort_order = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)
}
\arguments{
\item{release_id}{An integer ID of the release.}

\item{...}{These dots only exist for future extensions and should be empty.}

\item{filter_variable}{A string indicating which attribute to indicate the
attribute that results are filtered by.  Possible values include: \code{"frequency"},
\code{"units"}, \code{"seasonal_adjustment"}.  No filtering by default.}

\item{filter_value}{A string giving the value of the \code{filter_variable}
attribute to filter results by.  \code{filter_variable} must be set.  No filtering
by default.}

\item{tag_names}{A string indicating which series tags to match.  Multiple
tags can be delimited by a semicolon in a single string (e.g. `"usa;gnp"``).}

\item{exclude_tag_names}{A string indicating which series tags should \emph{not}
be matched.  Multiple tags can be delimited by a semicolon in a single string
(e.g. `"usa;gnp"``).}

\item{limit}{An integer limit on the maximum number of results to return.
Defaults to \code{1000}, the maximum.}

\item{offset}{An integer used in conjunction with \code{limit} for long series.
This mimics the idea of \emph{pagination} to retrieve large amounts of data over
multiple calls. Defaults to \code{0}.}

\item{order_by}{A string indicating an attribute by which the results are
ordered by. Possible values include:
\itemize{
\item \code{"series_id"} (default)
\item \code{"title"}
\item \code{"units"}
\item \code{"frequency"}
\item \code{"seasonal_adjustment"}
\item \code{"realtime_start"}
\item \code{"realtime_end"}
\item \code{"last_updated"}
\item \code{"observation_start"}
\item \code{"observation_end"}
\item \code{"popularity"}
\item \code{"group_popularity"}
}}

\item{sort_order}{A string representing the order of the resulting series.
Possible values are: \code{"asc"} (default), and \code{"desc"}.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object.
}
\description{
Get the series on a release of economic data
}
\section{API Documentation}{


\href{https://fred.stlouisfed.org/docs/api/fred/release_series.html}{fred/release/series}
}

\examples{
if (fredr_has_key()) {
fredr_release_series(release_id = 20L)

fredr_release_series(release_id = 20L, order_by = "popularity")

# Extract the "catalog" of series from a release on a certain date
fredr_release_series(
   release_id = 20L,
   realtime_end = as.Date("2018-07-13"),
   order_by = "popularity"
)
}
}
\seealso{
\code{\link[=fredr_releases]{fredr_releases()}}, \code{\link[=fredr_releases_dates]{fredr_releases_dates()}}, \code{\link[=fredr_release]{fredr_release()}},
\code{\link[=fredr_release_dates]{fredr_release_dates()}}, \code{\link[=fredr_release_sources]{fredr_release_sources()}}, \code{\link[=fredr_release_tags]{fredr_release_tags()}},
\code{\link[=fredr_release_related_tags]{fredr_release_related_tags()}}, \code{\link[=fredr_release_tables]{fredr_release_tables()}}
}
