% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ai_context.R
\name{ai_regenerate_context}
\alias{ai_regenerate_context}
\title{Regenerate Dynamic Sections in AI Context File}
\usage{
ai_regenerate_context(project_path = ".", sections = NULL, ai_file = NULL)
}
\arguments{
\item{project_path}{Path to the project directory}

\item{sections}{Which sections to regenerate. NULL = all regeneratable sections.
Options: "environment", "packages", "data", "functions"}

\item{ai_file}{Name of the AI context file (default: from settings or "CLAUDE.md")}
}
\value{
Invisible TRUE on success
}
\description{
Updates only the sections marked with \verb{<!-- @framework:regenerate -->} in an
existing AI context file, preserving user customizations in unmarked sections.
}
\examples{
\donttest{
if (file.exists("CLAUDE.md")) {
  # Regenerate all dynamic sections
  ai_regenerate_context()

  # Regenerate only packages section
  ai_regenerate_context(sections = "packages")
}
}
}
