% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleSelection.R
\name{select_Fpsn}
\alias{select_Fpsn}
\title{select_Fpsn}
\usage{
select_Fpsn(
  res_fpsn,
  method = "givenVariance",
  sigma = sdDiff(res_fpsn$signal)
)
}
\arguments{
\item{res_fpsn}{output of Fpsn or Fpsn_w containg the costs in J.est and the segmented signal}

\item{method}{one of (1) "givenVariance" = using the penalty of Lebarbier 2005 given a estimator of the variance, (2) "biggest.S3IB" = biggest=TRUE in saut taken from S3IB, (3) "notbiggest.S3IB"  biggest=FALSE in saut taken from S3IB.}

\item{sigma}{variance used of the selection. If NULL use MAD on unweighted data.}
}
\value{
return an integer: selected number of changes
}
\description{
function to select the number of changepoints after Fpsn or Fpsn_w
using the penalty of Lebarbier 2005 given a estimator of the variance
}
\examples{
x <- c(rnorm(100), rnorm(10^3)+2, rnorm(1000)+1)
res <- Fpsn_w(x=x, w=rep(1, length(x)), K=100)
select.res <- select_Fpsn(res, method="givenVariance")
smt <- getSMT(res, select.res)
}
