% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spline.R
\name{spline_model}
\alias{spline_model}
\title{Cubic spline stochastic model}
\usage{
spline_model(y, method = c("gcv", "mle"), lambda = NULL, biasadj = FALSE)
}
\arguments{
\item{y}{a numeric vector or univariate time series of class \code{ts}}

\item{method}{Method for selecting the smoothing parameter. If
\code{method = "gcv"}, the generalized cross-validation method from
\code{\link[stats:smooth.spline]{stats::smooth.spline()}} is used. If \code{method = "mle"}, the
maximum likelihood method from Hyndman et al (2002) is used.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda = "auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted
values, a regular back transformation will result in median forecasts. If
biasadj is \code{TRUE}, an adjustment will be made to produce mean forecasts
and fitted values.}
}
\value{
An object of class \code{spline_model}.
}
\description{
Fits a state space model based on cubic smoothing splines.
The cubic smoothing spline model is equivalent to an ARIMA(0,2,2) model but
with a restricted parameter space. The advantage of the spline model over
the full ARIMA model is that it provides a smooth historical trend as well
as a linear forecast function. Hyndman, King, Pitrun, and Billah (2002) show
that the forecast performance of the method is hardly affected by the
restricted parameter space.
}
\examples{
fit <- spline_model(uspop)
fit
fit |> forecast() |> autoplot()

}
\references{
Hyndman, King, Pitrun and Billah (2005) Local linear forecasts
using cubic smoothing splines. \emph{Australian and New Zealand Journal of
Statistics}, \bold{47}(1), 87-99.
\url{https://robjhyndman.com/publications/splinefcast/}.
}
\seealso{
\code{\link[stats:smooth.spline]{stats::smooth.spline()}}, \code{\link[stats:arima]{stats::arima()}}, \code{\link[=holt]{holt()}}.
}
\author{
Rob J Hyndman
}
\keyword{ts}
