% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_bbox.R
\name{filter_by_bbox}
\alias{filter_by_bbox}
\title{Filter FORCIS data by a spatial bounding box}
\usage{
filter_by_bbox(data, bbox)
}
\arguments{
\item{data}{a \code{tibble} or a \code{data.frame}. One obtained by \verb{read_*_data()}
functions.}

\item{bbox}{an object of class \code{bbox} (package \code{sf}) or a vector of four
\code{numeric} values defining a square bounding box. Values must follow this
order: minimum longitude (\code{xmin}), minimum latitude (\code{ymin}), maximum
longitude (\code{xmax}), and maximum latitude (\code{ymax}).
\strong{Important:} if a vector of numeric values is provided, coordinates must
be defined in the system WGS 84 (\code{epsg=4326}).}
}
\value{
A \code{tibble} containing a subset of \code{data} for the desired bounding
box.
}
\description{
Filters FORCIS data by a spatial bounding box.
}
\examples{
# Import example dataset ----
file_name <- system.file(file.path("extdata", "FORCIS_net_sample.csv"),
                         package = "forcis")

net_data <- read.csv(file_name)

# Dimensions of the data.frame ----
dim(net_data)

# Filter by oceans ----
net_data_sub <- filter_by_bbox(net_data, bbox = c(45, -61, 82, -24))

# Dimensions of the data.frame ----
dim(net_data_sub)
}
