% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_folders.R
\name{create_folders}
\alias{create_folders}
\title{Create Folders}
\usage{
create_folders(folders, showWarnings = FALSE, recursive = TRUE)
}
\arguments{
\item{folders}{(list) A named list of standard folders for an R project.}

\item{showWarnings}{(boolean) Show warnings. See: base::dir.create().
(Default: FALSE)}

\item{recursive}{(boolean) Support recursive folder creation. 
See: base::dir.create(). (Default: TRUE)}
}
\value{
(vector) A named vector for the results of "dir.create" operations.
}
\description{
Create a standardized set of folders under a parent folder of an R project.
}
\section{Details}{

For each folder in the "folders" list, here::here() and base::dir.create() are 
used to create a subfolder under the parent folder. Warnings are silenced in 
case the folder already exists. Recursive folder creation is supported. These
two features can be controlled with the "showWarnings" and "recursive"
parameters. A TRUE value in the returned vector means the folder was created 
by dir.create(). If a folder already exists, the returned vector will have a 
FALSE value for that folder.
}

\examples{
# Create list of standard folder names and store in a configuration file
conf_file <- tempfile("folders.yml")     # Using tempfile() for testing only
folders <- get_folders(conf_file)

# Testing only: Append folder names to parent folder path --
#               This would NOT be needed or desired in normal usage
folders <- lapply(folders, function(x) file.path(tempdir(), x))

# Create a folder for each item in "folders" list
result <- create_folders(folders)

# Check results
file.exists(conf_file)
sapply(folders, dir.exists)

# Create a data file and confirm that it exists
df <- data.frame(x = letters[1:3], y = 1:3)
file_path <- here::here(folders$data, "data.csv")
write.csv(df, file_path, row.names = FALSE)
file.exists(file_path)
}
\keyword{consistency}
