% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.fmx.R
\name{as.fmx.fitdist}
\alias{as.fmx.fitdist}
\title{Convert \link[fitdistrplus]{fitdist} Objects to \linkS4class{fmx} Class}
\usage{
\method{as.fmx}{fitdist}(x, ...)
}
\arguments{
\item{x}{\link[fitdistrplus]{fitdist} object}

\item{...}{..}
}
\value{
Function \code{\link[=as.fmx.fitdist]{as.fmx.fitdist()}} returns an \linkS4class{fmx} object.
}
\description{
To convert \link[fitdistrplus]{fitdist} objects (from package \CRANpkg{fitdistrplus})
to \linkS4class{fmx} class.
}
\examples{
library(fitdistrplus)
# ?fitdist
data(endosulfan, package = 'fitdistrplus')
ATV <- subset(endosulfan, group == 'NonArthroInvert')$ATV
log10ATV <- log10(ATV)
fln <- fitdist(log10ATV, distr = 'norm')
(fln2 <- as.fmx(fln))
hist.default(log10ATV, freq = FALSE)
curve(dfmx(x, dist = fln2), xlim = range(log10ATV), add = TRUE)

}
