% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external.R
\name{external}
\alias{external}
\title{Multidimensional External Unfolding Function}
\usage{
external(
  x,
  w = NULL,
  fixed = NULL,
  z = NULL,
  MAXITER = 1024,
  FCRIT = 1e-08,
  error.check = FALSE,
  echo = FALSE
)
}
\arguments{
\item{x}{an n by m rectangular matrix containing dissimilarities or distances.}

\item{w}{an identical sized matrix containing nonnegative weights (all ones when omitted).}

\item{fixed}{fixed column coordinates (m x p).}

\item{z}{null or initial row coordinates (n by p).}

\item{MAXITER}{maximum number of iterations (default = 1024).}

\item{FCRIT}{relative convergence criterion (default = 0.00000001).}

\item{error.check}{extensive check validity input parameters (default = FALSE).}

\item{echo}{print intermediate algorithm results (default = FALSE).}
}
\value{
x original n by m matrix with dissimilarities or distances.

w original n by m matrix with dissimilarity weights.

fixed original m x p fixed column coordinates.

z final n by p matrix with row coordinates.

d final n by m matrix with distances between rows of z and rows of fixed.

last.iteration final iteration number.

last.difference final function difference used for convergence testing.

mse final mean squared error function value.

rmse final root mean squared error function value.
}
\description{
\code{external} performs multidimensional external unfolding.
}
\examples{
\dontrun{
library( smacof )
data( "breakfast" )
x <- as.matrix( breakfast )
n <- nrow( x )
m <- ncol( x )
d.col <- as.matrix( dist( t( x ) ) )
r <- smacofSym( d.col )
print( r$conf )
e <- external( x, fixed = r$conf )
print( e$z )
}

}
\references{
de Leeuw, J., and Heiser, W. J. (1980). Multidimensional scaling with restrictions on the configuration.
            In P.R. Krishnaiah (Ed.), Multivariate analysis (Vol. 5, pp. 501–522).
            Amsterdam, The Netherlands: North-Holland Publishing Company.

            Heiser,W. J. (1987a). Joint ordination of species and sites: The unfolding technique.
            In P. Legendre and L. Legendre (Eds.), Developments in numerical ecology (pp. 189–221).
            Berlin, Heidelberg: Springer-Verlag.

            Busing, F.M.T.A. (2010). Advances in multidimensional unfolding.
            Unpublished doctoral dissertation, Leiden University, Leiden, the Netherlands.
}
