% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcoa.R
\name{pcoa}
\alias{pcoa}
\title{Classical Multidimensional Scaling Function}
\usage{
pcoa(
  delta = NULL,
  lower = NULL,
  data = NULL,
  p = 2,
  k = NULL,
  ac = 0,
  q = NULL,
  faster = FALSE,
  error.check = FALSE
)
}
\arguments{
\item{delta}{dissimilarity matrix, non-negative, square, and hollow.}

\item{lower}{lower triangular part of dissimilarity matrix.}

\item{data}{multivariate data matrix.}

\item{p}{dimensionality (default = 2).}

\item{k}{number of landmark points (default = NULL, i.e., no landmarks).}

\item{ac}{additive constant (default = 0.0, i.e., no additive constant).
An additive constant can be obtained with the function fastaddconst( d ) or can be user specified.}

\item{q}{matrix with h independent n-sized variables ( nrow( q ) >= p ),
specifying the linear restriction z = qb (coordinates = variables times coefficients)}

\item{faster}{logical indicating faster but less precise procedure}

\item{error.check}{extensive check validity input parameters (default = FALSE).}
}
\value{
either n by p coordinates matrix (if q == NULL)
        or h by p coefficients matrix b (if q != NULL), in which case z = qb
}
\description{
\code{pcoa} performs classical multidimensional scaling or principal coordinates analysis.
The function uses an eigenvalue decomposition on a Gramm matrix.
The data are supposed to be distances, but often dissimilarities will do fine.
The data matrix contains nonnegative values, is square, symmetric, and hollow.
NA's are not allowed.
An additive constant may be provided, which is added to the dissimilarities.
This constant might be obtained optimally with the function fastaddconst().
Error checking focuses on the data requirements.
}
\references{
Young and Householder (1938)
            Torgerson (1952, 1958)
            Gower (1966)
            Carroll, Green, and Carmone (1976)
            De Leeuw and Heiser (1982)
            Ter Braak (1992)
            Borg and Groenen (2005)
}
\author{
Frank M.T.A. Busing
}
