% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_unique_common_pg.R
\name{trace_unique_common_pg}
\alias{trace_unique_common_pg}
\title{Trace unique_common categorization for proteinGroup level}
\usage{
trace_unique_common_pg(
  input_df1,
  input_df2,
  analysis_name1 = "input_df1",
  analysis_name2 = "input_df2",
  string_analysis = FALSE
)
}
\arguments{
\item{input_df1}{A tibble with flowTraceR's unique_common categorization for the proteinGroup_precursor connection.}

\item{input_df2}{A tibble which is the counter part for input_df1 - which was used to generate the unique_common categorization for the proteinGroup_precursor connection.}

\item{analysis_name1}{String. Appended to input_df1's traceR_proteinGroups column - default is \code{"input_df1"}.}

\item{analysis_name2}{String. Appended to input_df1's traceR_proteinGroups column - default is \code{"input_df2"}.}

\item{string_analysis}{Logical value, default is \code{FALSE}. If TRUE, only keeps proteinGroup identifications of input_df1 in which protein denotations are not present in the counterpart - the proteinGroups of input_df2 - and vice versa.}
}
\value{
This function returns a \code{tibble} with the following columns :
\itemize{
\item traceR_proteinGroups_input_df1 - proteinGroup denotations of input_df1 for common precursor between input_df1 and input_df2
\item traceR_precursor - common precursor between input_df1 and input_df2
\item traceR_proteinGroups_input_df2 - proteinGroup denotations of input_df2 for common precursor between input_df1 and input_df2
}
}
\description{
Unique_common categorizations are analyzed on proteinGroup level
}
\details{
For each submitted dataframe the unique_common proteinGroup_precursor connection is analyzed to highlight potential differences in proteinGroup denotations for common precursors.
}
\examples{
# Load libraries
library(dplyr)
library(stringr)
library(tibble)

# DIA-NN example data
diann <- tibble::tibble(
  "traceR_connected_pg_prec" = c("common_common", "common_unique",
  "unique_common", "unique_common"),
  "traceR_proteinGroups" = c("P02768", "P02671", "Q92496", "P04433"),
  "traceR_precursor" = c("AAC(UniMod:4)LLPK1", "RLEVDIDIK2",
  "EGIVEYPR2", "ASQSVSSYLAWYQQK2"),
)

# Spectronaut example data
spectronaut <- tibble::tibble(
  "traceR_connected_pg_prec" = c("common_common", "common_unique",
  "unique_common", "unique_common"),
  "traceR_proteinGroups" = c("P02768", "P02671", "Q02985", "A0A0A0MRZ8;P04433"),
  "traceR_precursor" = c("AAC(UniMod:4)LLPK1", "M(UniMod:35)KPVPDLVPGNFK2",
  "EGIVEYPR2", "ASQSVSSYLAWYQQK2"),
)

# Find difference in pg denotation
# string_analysis = TRUE
resultA <- trace_unique_common_pg(input_df1 = diann,
 input_df2 = spectronaut,
 analysis_name1 = "DIA-NN",
 analysis_name2 = "Spectronaut",
 string_analysis = TRUE)

# Find difference in pg denotation
# string_analysis = FALSE
# compare with resultA
resultB <- trace_unique_common_pg(input_df1 = diann,
 input_df2 = spectronaut,
 analysis_name1 = "DIA-NN",
 analysis_name2 = "Spectronaut",
 string_analysis = FALSE)
}
\author{
Oliver Kardell
}
