% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_sports_race_data.R
\name{bind_sports_race_data}
\alias{bind_sports_race_data}
\title{Bind sports race data}
\usage{
bind_sports_race_data(
  .,
  data = NULL,
  name = NULL,
  times = NULL,
  start_image = NULL,
  race_image = NULL,
  finish_image = NULL,
  color_category = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{data}{Data.}

\item{name}{Name. Name of competitor. Flourish type hint: column}

\item{times}{Times. One or more columns of numbers, representing splits or laps, or a whole race. Flourish type hint: columns}

\item{start_image}{Start image. The image to use at the start of the race. Add an image URL or right-click on a cell to upload an image. Flourish type hint: column}

\item{race_image}{Racing image. The image to use while a participant is racing. Add an image URL or right-click on a cell to upload an image. Flourish type hint: column}

\item{finish_image}{Finish image. The image to use when the participant has finished the race. Add an image URL or right-click on a cell to upload an image. Flourish type hint: column}

\item{color_category}{Color category. Add a category to color participants by. If empty, the name column will be used for colors. Flourish type hint: column}
}
\value{
A Flourish chart
}
\description{
Bind sports race data
}
\examples{
try(
  flourish(chart_type = "sports_race", api_key = Sys.getenv("FLOURISH_API_KEY")) |> 
  bind_sports_race_data(gapminder)
)
}
