% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_quiz_data.R
\name{bind_quiz_data}
\alias{bind_quiz_data}
\title{Bind quiz data}
\usage{
bind_quiz_data(
  .,
  questions_data = NULL,
  scores_data = NULL,
  results_data = NULL,
  questions_text = NULL,
  questions_explanation = NULL,
  questions_input_type = NULL,
  questions_answers = NULL,
  questions_suffix = NULL,
  questions_choices = NULL,
  scores_question = NULL,
  scores_range = NULL,
  scores_explanation = NULL,
  scores_media = NULL,
  results_range = NULL,
  results_text = NULL,
  results_media = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{questions_data}{Questions data.}

\item{scores_data}{Scores data.}

\item{results_data}{Results data.}

\item{questions_text}{Text. Question text. Flourish type hint: column}

\item{questions_explanation}{Explanation. A short text explanation accompanying the question. Flourish type hint: column}

\item{questions_input_type}{Input type. Type of answer input, choose between slider or multiple choice Flourish type hint: column}

\item{questions_answers}{Answers. The correct answer to the question. The score will be decided by the difference between this answer and your input.  Its possible to select multiple columns with answers; this will create a dropdown list above the quiz where you can select which answer to compare to. Flourish type hint: columns}

\item{questions_suffix}{Slider input suffix. Add a suffix after the value, eg. "\%" or "people" (only for slider input type). Flourish type hint: column}

\item{questions_choices}{Multiple choice options. Options to show in multiple choice questions. Divide using "::" (eg. "Cat :: Dog :: Sheep :: Badger"). Flourish type hint: column}

\item{scores_question}{Question. Question that the answer belongs to. Flourish type hint: column}

\item{scores_range}{Answer. The answer to the question. This can be text for multiple choice questions. For slider answers, you can use numbers or number ranges, values could be "0-10" or "4" or "\emph{" to select all answers.  You can also add multiple rows with score ranges per question; the more specific scores will take priority (e.g. it will choose "4" over "0-10" over "}"). Flourish type hint: column}

\item{scores_explanation}{Text. Text to show after answering question. Flourish type hint: column}

\item{scores_media}{Media. Picture to show after answering question. Flourish type hint: column}

\item{results_range}{Points range. A range of points youre targeting. You can use numbers or number ranges, values could be "0-10" or "4" or "\emph{" to select all answers.  You can also add multiple rows with score ranges per question; the more specific scores will take priority (e.g. it will choose "4" over "0-10" over "}"). Flourish type hint: column}

\item{results_text}{Results text}

\item{results_media}{Media. An image to show with the result. Add an image URL or right-click on a cell to upload an image. Flourish type hint: column}
}
\value{
A Flourish chart
}
\description{
Bind quiz data
}
\examples{
try(
  flourish(chart_type = "quiz", api_key = Sys.getenv("FLOURISH_API_KEY")) |> 
  bind_quiz_data(gapminder)
)
}
