% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_pictogram_data.R
\name{bind_pictogram_data}
\alias{bind_pictogram_data}
\title{Bind pictogram data}
\usage{
bind_pictogram_data(
  .,
  data = NULL,
  icons_data = NULL,
  main_category = NULL,
  sub_category = NULL,
  values = NULL,
  icon_id = NULL,
  color = NULL,
  metadata = NULL,
  icons_id = NULL,
  icons_path_string = NULL,
  icons_width = NULL,
  icons_height = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{data}{Data.}

\item{icons_data}{Icons data.}

\item{main_category}{Main category. The (categorical) column that defines the categories along the main axis. Flourish type hint: column}

\item{sub_category}{Subcategory. The (categorical) column that defines the categories within each bar. Flourish type hint: column}

\item{values}{Values. (Optional) Choose the numeric columns to determine the size of each bar.  If more than 1 is chosen, a dropdown will appear in the visualization, which lets the user choose. Flourish type hint: columns}

\item{icon_id}{Icon ID. IDs for joining icons in the Icons datasheet.  Must contain IDs that match Icon ID values in Icons Set to the same column as the Main category or Subcategory. Flourish type hint: column}

\item{color}{Color. The (categorical) column which determines the icon color. Set to the same column as the Main category or Subcategory. Flourish type hint: column}

\item{metadata}{Info for popups. One or more columns of information (text, image URLs, embedded charts etc) to include in popups and panels Flourish type hint: columns}

\item{icons_id}{Icon ID. Unique ID for joining icon path strings. Must contain IDs that match the Icon ID values in DataFlourish type hint: column}

\item{icons_path_string}{Icon. Icon path string (e.g. "M10,10 l80,0 l0,80 l-80,0 z") or the name of a built-in icon (e.g. "female"). Flourish type hint: column}

\item{icons_width}{Icon width. Icon width (in pixels). Flourish type hint: column}

\item{icons_height}{Icon height. Icon height (in pixels). Flourish type hint: column}
}
\value{
A Flourish chart
}
\description{
Bind pictogram data
}
\examples{
try(
  flourish(chart_type = "pictogram", api_key = Sys.getenv("FLOURISH_API_KEY")) |> 
  bind_pictogram_data(gapminder)
)
}
