% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-classify-grid-water.R
\name{classify_grid_water}
\alias{classify_grid_water}
\title{Create the DEGURBA grid cell classification of water cells}
\usage{
classify_grid_water(
  data,
  classification = NULL,
  water_land_threshold = 0.5,
  water_pop_threshold = 0,
  water_built_threshold = 0,
  value = 0,
  allow_overwrite = c(1)
)
}
\arguments{
\item{data}{path to the directory with the data, or named list with the data as returned by function \code{\link[=DoU_preprocess_grid]{DoU_preprocess_grid()}}}

\item{classification}{SpatRaster. A grid to which the classification of water cells will be added. The grid can already contain the classification or urban centres, urban clusters and rural grid cell, but this is not mandatory. Note that the grid will be adapted in-place.}

\item{water_land_threshold}{numeric. Maximum proportion of permanent land allowed in a water cell}

\item{water_pop_threshold}{numeric. Maximum population size allowed in a water cell}

\item{water_built_threshold}{numeric. Maximum built-up area allowed in a water cell}

\item{value}{integer. Value assigned to water cells in the resulting grid}

\item{allow_overwrite}{vector. Values in \code{classification} that can be overwritten by water cells. By default, the classification of rural cells (\code{1}) can be overwritten, but the classification of urban clusters (\code{2}) and urban centres (\code{3}) cannot.}
}
\value{
SpatRaster with the grid cell classification of water cells
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{classify_grid_water()} has been renamed to \code{DoU_classify_grid_water()} to create a more consistent API and to better indicate that this function is specifically designed to classify water in the context of the DEGURBA classification.
}
\keyword{internal}
