% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{greek2b}
\alias{greek2b}
\title{Find the b Vector from a Greek-Letter Parameterization of Item Parameters.}
\usage{
greek2b(xi, omega, alpha = NULL, tau = NULL)
}
\arguments{
\item{xi}{see details}

\item{omega}{see details}

\item{alpha}{see details, vector of length k, set to NULL if k = 0}

\item{tau}{see details, vector of length k, set to NULL if k = 0}
}
\value{
A vector of item parameters in the b parameterization.
}
\description{
Convert the Greek-letter parameterization of item parameters (used to ensure
monotonicitiy) to the b-vector parameterization (polynomial coefficients).
}
\details{
For
\deqn{m(\theta) = b_{0} + b_{1}\theta + b_{2}\theta^2 + \cdots +
b_{2k+1}\theta^{2k+1}}{m(\theta) = b0 + b1\theta + b2\theta^2 + ... +
b(2k+1)\theta^{2k+1}}
to be a monotonic function, a necessary and sufficient condition is that its
first derivative,
\deqn{p(\theta) = a_{0} + a_{1}\theta + ... + a_{2k}\theta^{2k},}{p(\theta)
= a0 + a1\theta + ... + a(2k)\theta^{2k},}
is nonnegative at all theta. Here, let
\deqn{b_{0} = \xi}{b0 = \xi}
be the constant of integration and
\deqn{b_{s} = a_{s-1}/s}{b(s) = a(s-1)/s}
for \eqn{s = 1, 2, ..., 2k+1}.
Notice that \eqn{p(\theta)} is a polynomial function of degree \eqn{2k}.
A nonnegative polynomial of an even degree can be re-expressed as the
product of k quadratic functions.

If \eqn{k \geq 1}{k >= 1}:
\deqn{p(\theta) =  \exp{\omega} \Pi_{s=1}^{k}[1 - 2\alpha_{s}\theta +
(\alpha_{s}^2+ \exp(\tau_{s}))\theta^2]}{p(\theta) = exp{\omega}
\Pi_{s=1}^{k}[1 - 2\alpha(s)\theta + (\alpha(s)^2+ exp(\tau(s)))\theta^2]}

If \eqn{k = 0}:
\deqn{p(\theta) = 0.}
}
\examples{

(bvec <- greek2b(xi = 0, omega = 1, alpha = .1, tau = -1))
## 0.0000000  2.7182818 -0.2718282  0.3423943

(b2greek(bvec))
##  0.0  1.0  0.1 -1.0

}
\references{
Liang, L., & Browne, M. W. (2015). A quasi-parametric method for
fitting flexible item response functions. \emph{Journal of Educational and
Behavioral Statistics}, \emph{40}, 5--34. \doi{10.3102/1076998614556816}
}
\seealso{
\link{b2greek}
}
