% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic_exact.R
\name{ic_exact}
\alias{ic_exact}
\title{One-Shot Iman–Conover Transformation}
\usage{
ic_exact(x, target_r)
}
\arguments{
\item{x}{A numeric matrix or data frame with independent columns (desired marginals).}

\item{target_r}{A square, positive-definite correlation matrix to impose.}
}
\value{
A numeric matrix with the same marginal distributions as \code{x} and
approximately matching the target Spearman correlation.
}
\description{
Applies the classic Iman–Conover procedure to reorder the columns of a numeric matrix
to approximately match a target rank correlation structure, while preserving marginals.
}
\examples{
set.seed(123)
x <- matrix(rnorm(300), ncol = 3)
R_target <- matrix(c(1, 0.5, 0.3,
                     0.5, 1, 0.4,
                     0.3, 0.4, 1), 3)
out <- ic_exact(x, R_target)
cor(out, method = "spearman")
}
