% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_hasParent}
\alias{fxml_hasParent}
\title{Parent of an XML element}
\usage{
fxml_hasParent(xmlflat.df, elemid)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}
}
\value{
\code{TRUE}, if a parent element for the XML element with ID \code{elemid} exists, \code{FALSE} otherwise (which would mean that the XML element is the root node of the XML document).
}
\description{
Determines, if an XML element has a parent element.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Check if the XML element with ID 4 (xml.dataframe$elemid. ==  4) has a parent element
fxml_hasParent(xml.dataframe, 4)
}
\seealso{
\code{\link{fxml_getParent}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
