% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness_of_fit.R
\name{goodness_of_fit}
\alias{goodness_of_fit}
\title{Calculate the Chi^2 and G^2 Statistics}
\usage{
goodness_of_fit(model, type = "Chisq", ...)
}
\arguments{
\item{model}{a GLM regression model.}

\item{type}{either "Chisq" or "Gsq", which determines the type of goodness of fit test that is ran. Defaults to "Chisq".}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A list with class "\code{ct_goodness_of_fit}" containing the following components:

\code{test} the type of test used.

\code{model} the name of the inputted model.

\code{statistic} The value of the test statistic as determined by the type parameter

\code{df} The number of degrees of freedom.
  This equals the number of combinations for explanatory variables less the number of parameters in the model

\code{p.value} The p-value calculated under a Chi-Squared distribution.
}
\description{
Calculates the goodness of fit test statistics for contingency tables
}
\examples{
lung_logit <-
  lung_cancer \%>\%
  flatten_ct() \%>\%
  glm(
    Lung ~ Smoking
    ,family = binomial
    ,data = .
  )

goodness_of_fit(model = lung_logit, type = "Chisq")
lung_logit \%>\%
  goodness_of_fit(type = "Gsq")
lung_cancer \%>\%
  flatten_ct() \%>\%
  glm(
    Lung ~ City + Smoking
    ,family = binomial
    ,data = .
  ) \%>\%
  goodness_of_fit()

}
