#-----------------------------------------------------------------------------------#
# Package: flare                                                                    #
# sugm.plot(): graph visualization                                                  #
# Author: Xingguo Li                                                                #
# Email: <xingguo.leo@gmail.com>                                                    #
# Date: Dec 2nd 2013                                                                #
# Version: 1.1.0                                                                    #
#-----------------------------------------------------------------------------------#

sugm.plot <- function(G, epsflag = FALSE, graph.name = "default", cur.num = 1, location=NULL){
  gcinfo(FALSE)
  if(missing(location))	location = getwd()
  g = graph_from_adjacency_matrix(as.matrix(G!=0), mode="undirected", diag=FALSE)
  layout.grid = layout_with_fr(g)
  
  if(epsflag == TRUE)	postscript(file.path(location, paste(paste(graph.name, cur.num, sep=""), "eps", sep=".")), width = 8.0, height = 8.0)
  par(mfrow = c(1,1))
  plot(g, layout=layout.grid, edge.color='gray50',vertex.color="red", vertex.size=2, vertex.label=NA)
  rm(g,location)	
  gc()
  if(epsflag == TRUE) dev.off()
}
