% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R, R/zzz_aliases.R
\name{plotFitDSTP}
\alias{plotFitDSTP}
\alias{plot_fit_dstp}
\title{Plot the fit of the DSTP model to human data.}
\usage{
plotFitDSTP(
  modelFit,
  data,
  conditionName = NULL,
  nTrials = 50000,
  cdfs = c(0.1, 0.3, 0.5, 0.7, 0.9),
  cafs = c(0.25, 0.5, 0.75),
  multipleSubjects = TRUE,
  seed = NULL
)

plot_fit_dstp(
  modelFit,
  data,
  conditionName = NULL,
  nTrials = 50000,
  cdfs = c(0.1, 0.3, 0.5, 0.7, 0.9),
  cafs = c(0.25, 0.5, 0.75),
  multipleSubjects = TRUE,
  seed = NULL
)
}
\arguments{
\item{modelFit}{The object obtained by the model fit.}

\item{data}{The data frame of human data.}

\item{conditionName}{The name of the condition that was fit. By default,
it is set to conditionName = NULL.}

\item{nTrials}{How many trials used to generate the model's best
predictions. This should be higher than that used to fit the model.}

\item{cdfs}{The cut-off points for the cumulative distribution functions.}

\item{cafs}{The cut-off points for the conditional accuracy functions.}

\item{multipleSubjects}{A boolean stating whether the fit is to multiple
subjects (multipleSubjects = TRUE) or to a single subject
(multipleSubjects = FALSE).}

\item{seed}{The value for the \code{set.seed} function to set random
generation state.}
}
\value{
\code{cdfs} The CDF values requested by the user.

\code{cafs} The CAF values requested by the user.

\code{humanConCDFs} The response time cut-off values for each CDF
bin for congruent human data.

\code{humanInconCDFs} The response time cut-off values for each CDF
bin for incongruent human data.

\code{humanConCAFsRT} The mean response times for each bin of the
CAF functions for congruent human data.

\code{humanInconCAFsRT} The mean response times for each bin of the
CAF functions for incongruent human data.

\code{humanConCAFsError} The percent accuracy for each bin of the
CAF functions for congruent human data.

\code{humanConCAFsError} The percent accuracy for each bin of the
CAF functions for congruent human data.

\code{modelConCDFs} The quantile cut-off points for the model
predictions for congruent data. A perfect fit would match the cdfs asked
for by the user (e.g., .1, .3, .5, .7, .9).

\code{modelInconCDFs} The quantile cut-off points for the model
predictions for incongruent data. A perfect fit would match the cdfs asked
for by the user (e.g., .1, .3, .5, .7, .9).

\code{modelConCAFs} The percentage accuracy predicted for each CAF
bin by the model for congruent data.

\code{modelInconCAFs} The percentage accuracy predicted for each CAF
bin by the model for incongruent data.
}
\description{
\code{plotFitDSTP} will plot the fit of the model to human distributional
data.
}
\details{
This function is passed the object obtained by the model fitting procedure,
as well as the human data and the condition that was fitted by the routine.
The function simulates 100,000 trials (by default) using the best-fitting
parameters found by the fit procedure. This synthetic data is then considered
as the model's best predictions. The function then provides a plot of the
model fit to cumulative distribution functions (CDFs) of correct response
time, and conditional accuracy functions (CAFs) to show fit to accuracy data.
The function also returns the data used to plot the fit so that the user can
use their own plotting methods.
}
\examples{
# Assume that the model was just fit to the data contained in
# \code{exampleData} (condition "present") and saved to the variable called
# "fit", then we can obtain a plot of that fit by using the following:
# (Note this is a toy example with very low trial numbers to speed up the
# example. For proper use, increase nTrials.)
fit <- fitDSTP(data = exampleData, conditionName = "present", nTrials = 100)
plot <- plotFitDSTP(modelFit = fit, data = exampleData,
                    conditionName = "present", nTrials = 100)

}
