% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propagate_flag.R
\name{propagate_flag}
\alias{propagate_flag}
\title{Derive flags for an aggregates using diffrent methods}
\usage{
propagate_flag(flags, method = "", codelist = NULL, flag_weights = 0,
  threshold = 0.5)
}
\arguments{
\item{flags}{A data.frame or a matrix containing the flags of the series (one column per period)
without row identifiers (e.g. country code).}

\item{method}{A string contains the method to to derive the flag for the aggregate. It can take the value,
"hierarchy", "frequency" or "weighted".}

\item{codelist}{A string or character vector defining the list of acceptable flags in case the method "hierarchy"
is chosen. In case of the string equals to "estat" or "sdmx" then the predefined standard Eurostat and SDMX codelist
is used, otherwise the characters in the sring will define the hierarchical order.}

\item{flag_weights}{A data.frame or a matrix containing the corresponding weights of the series (one column per
period) without row identifiers (e.g. country code). It has the same size and dimesion as the \code{flags} parameter.}

\item{threshold}{The threshold which above the should be the waights in order the aggregate to receive a flag.
Defalut value is 0.5, but can be changed to any value.}
}
\value{
\code{propagate_flag} returns a list with the same size as the number of periods (columns) in the flags
parameter. In case of the methods is "hierarchy" or "frequency", then only the derived flag(s) is returned. In case
of weighted it returns the flag(s) and the sum of weights if it is above the threshold, otherwise the list contains
\code{NA} where the sum of weights are below the threshold.
}
\description{
The wrapper function to use the different method and provide a structured return value independently
 from the method used.
}
\examples{
flags <- tidyr::spread(test_data[, c(1:3)], key = time, value = flags)
weights <- tidyr::spread(test_data[, c(1, 3:4)], key = time, value = values)

propagate_flag(flags[, c(2:ncol(flags))],"hierarchy","puebscd")
propagate_flag(flags[, c(2:ncol(flags))],"hierarchy","estat")
propagate_flag(flags[, c(2:ncol(flags))],"frequency")

flags<-flags[, c(2:ncol(flags))]
weights<-weights[, c(2:ncol(weights))]
propagate_flag(flags,"weighted",flag_weights=weights)
propagate_flag(flags,"weighted",flag_weights=weights,threshold=0.1)

}
\seealso{
\code{\link{flag_hierarchy}}, \code{\link{flag_frequency}}, \code{\link{flag_weighted}}
}
