% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_data_reliability.R
\name{check_data_reliability}
\alias{check_data_reliability}
\title{Check inter-rater or test-retest reliability between numeric columns}
\usage{
check_data_reliability(df)
}
\arguments{
\item{df}{A data frame}
}
\value{
A message indicating whether the data is reliable or not between each
        pair of columns.
}
\description{
This function checks for inter-rater or test-retest reliability between all
pairs of numeric columns in a data frame by computing the correlation between
each pair and reporting if it is less than 0.8.
}
\examples{
df <- data.frame(x = c("a", "b", "c"), y = c(4, 5, 6), z = c(7, 8, 180))
check_data_reliability(df)

}
