% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{resid.fixest}
\alias{resid.fixest}
\alias{residuals.fixest}
\title{Extracts residuals from a \code{fixest} object}
\usage{
\method{resid}{fixest}(
  object,
  type = c("response", "deviance", "pearson", "working"),
  na.rm = TRUE,
  ...
)

\method{residuals}{fixest}(
  object,
  type = c("response", "deviance", "pearson", "working"),
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{object}{A \code{fixest} object. Obtained using the functions \code{\link{femlm}}, \code{\link{feols}} or \code{\link{feglm}}.}

\item{type}{A character scalar, either \code{"response"} (default), \code{"deviance"},
\code{"pearson"}, or \code{"working"}. Note that the \code{"working"} corresponds to the residuals
from the weighted least square and only applies to \code{\link{feglm}} models.}

\item{na.rm}{Logical, default is \code{TRUE}. Whether to remove the observations with NAs
from the original data set. If \code{FALSE}, then the vector returned is always of the same
length as the original data set.}

\item{...}{Not currently used.}
}
\value{
It returns a numeric vector of the length the number of observations used for the estimation
(if \code{na.rm = TRUE}) or of the length of the original data set (if \code{na.rm = FALSE}).
}
\description{
This function extracts residuals from a fitted model estimated with \code{\link{femlm}},
\code{\link{feols}} or \code{\link{feglm}}.
}
\examples{

# simple estimation on iris data, using "Species" fixed-effects
res_poisson = femlm(Sepal.Length ~ Sepal.Width + Petal.Length +
                    Petal.Width | Species, iris)

# we plot the residuals
plot(resid(res_poisson))

}
\seealso{
See also the main estimation functions \code{\link{femlm}}, \code{\link{feols}} or \code{\link{feglm}}. \code{\link{fitted.fixest}}, \code{\link{predict.fixest}}, \code{\link{summary.fixest}}, \code{\link{vcov.fixest}}, \code{\link{fixef.fixest}}.
}
\author{
Laurent Berge
}
