% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmix.R
\name{rmix}
\alias{rmix}
\title{The mixture random generation for the well-known models}
\usage{
rmix(N, model, K, param)
}
\arguments{
\item{N}{Number of inputs for the mixture random generation}

\item{model}{Choice of one of the mixture models; \code{gompertz}, \code{log-logistics}, \code{log-normal}, and \code{weibull}.}

\item{K}{Number of components}

\item{param}{Vector of weight \eqn{\omega}, shape \eqn{\alpha}, and scale \eqn{\beta} parameters.}
}
\value{
Outputs of random generated vector lenght of N from the given mixture model.
}
\description{
Random generation for the well-known mixture models with parameters \code{weigth}, \code{shape} and \code{scale}.
}
\examples{
N<-100
K<-2
weight<-c(0.5,0.5)
alpha<-c(0.5,1)
beta<-c(1,0.5)
param<-c(weight,alpha,beta)
rmix(N, "weibull", K, param)
}
