% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_vectorfield.R
\name{fast_bilinear}
\alias{fast_bilinear}
\title{A fast bilinear interpolation function}
\usage{
fast_bilinear(x, y, z, x0, y0)
}
\arguments{
\item{x}{
    a vector containing the \code{x} coordinates of the rectangular data grid.
  }

\item{y}{
    a vector containing the \code{y} coordinates of the rectangular data grid.
  }

\item{z}{
    a matrix containing the \code{z[i,j]} data values for the grid points (\code{x[i]},\code{y[j]}).
  }

\item{x0}{\code{x} value used to interpolate at.}

\item{y0}{\code{y} value used to interpolate at.}
}
\value{
A list which contains only one element, \code{z}.
}
\description{
It assumes equal grid intervals, thus can find the correct position in \eqn{O(1)} time.
}
\details{
The following is from the documentation of \code{\link[akima:bilinear]{akima::bilinear()}}.

This is an implementation of a bilinear interpolating function.
For a point (x0,y0) contained in a rectangle (x1,y1),(x2,y1), (x2,y2),(x1,y2) and x1<x2, y1<y2, the first step is to get z() at locations (x0,y1) and (x0,y2) as convex linear combinations z(x0,y*)=a\emph{z(x1,y})+(1-a)\emph{z(x2,y}) where a=(x2-x1)/(x0-x1) for y*=y1,y2. In a second step z(x0,y0) is calculated as convex linear combination between z(x0,y1) and z(x0,y2) as z(x0,y1)=b*z(x0,y1)+(1-b)*z(x0,y2) where b=(y2-y1)/(y0-y1).

Finally, z(x0,y0) is a convex linear combination of the z values at the corners of the containing rectangle with weights according to the distance from (x0,y0) to these corners.
}
\keyword{internal}
