% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top_plot.R
\name{top_plot}
\alias{top_plot}
\title{Plot Top Entries}
\usage{
top_plot(
  x,
  field = NULL,
  ntop = NULL,
  highlight = NULL,
  max.char = Inf,
  show.rest = FALSE,
  show.percentage = FALSE,
  log10 = FALSE
)
}
\arguments{
\item{x}{Data frame, vector or factor}

\item{field}{Field to show}

\item{ntop}{Number of top entries to show}

\item{highlight}{Entries from the 'field' to be highlighted}

\item{max.char}{Max number of characters in strings. Longer strings will be cut and only max.char first characters are shown. No cutting by default}

\item{show.rest}{Show the count of leave-out samples (not in top-N) as an additional bar.}

\item{show.percentage}{Show the proportion of each category with respect to the total sample count.}

\item{log10}{Show the counts on log10 scale (default FALSE)}
}
\value{
ggplot object
}
\description{
Visualizes the top entries for a given field in a data frame.
Count and percentage statistics is also shown as needed.
}
\examples{
\dontrun{p <- top_plot(x, field, 50)}
}
\references{
See citation("bibliographica")
}
\author{
Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{utilities}
