% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{error_minimize3}
\alias{error_minimize3}
\title{Minimize the Error for Remaining K-mer Frequency}
\usage{
error_minimize3(
  tooptimize,
  x,
  end,
  xfit_left,
  xfit_right,
  d,
  min_valid_pos,
  itr,
  meanfit,
  sdfit
)
}
\arguments{
\item{tooptimize}{A numeric vector containing the scale factors to optimize.}

\item{x}{A numeric vector representing the histogram.}

\item{end}{An integer indicating the right-side position for fitting.}

\item{xfit_left}{A numeric value for the left-side position to calculate initial mean and standard deviation.}

\item{xfit_right}{A numeric value for the right-side position to calculate initial mean and standard deviation.}

\item{d}{A data frame representing the observed k-mer frequencies that will be fitted.}

\item{min_valid_pos}{An integer indicating the left-side position from which the observed k-mer frequencies will be fitted.}

\item{itr}{An integer representing the iteration count.}

\item{meanfit}{A numeric value representing the initial mean.}

\item{sdfit}{A numeric value representing the initial standard deviation.}
}
\value{
A numeric value representing the minimized error.
}
\description{
This function minimizes the error for the remaining k-mer frequency by adjusting the scaling factor.
}
\examples{

tooptimize <- c(1, 1, 1, 1)
x <- rnorm(100)
end <- 100
xfit <- seq(min(x), max(x), length=end)
xfit_left <- 20
xfit_right <- 80
d <- data.frame(V1=1:100, V2=rnorm(100))
min_valid_pos <- 10
itr <- 100
meanfit <- 18
sdfit <- 4.21
error <- error_minimize3(tooptimize, x, end, xfit_left, xfit_right, d,
min_valid_pos, itr, meanfit, sdfit)
print(error)

}
