% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_utils.R
\name{expand_inds}
\alias{expand_inds}
\title{Form `fic` model indicator argument in presence of factors}
\usage{
expand_inds(inds, wide)
}
\arguments{
\item{inds}{Matrix or vector of indicators for which parameters are included in the submodel or submodels to be assessed.

A matrix should be supplied if there are multiple submodels.  This should have number of rows equal to the number of submodels, and number of columns equal to the total number of parameters in the wide model.  It contains 1s in the positions where the parameter is included in the submodel, and 0s in positions where the parameter is excluded.  This should always be 1 in the positions defining the narrow model, as specified in \code{inds0}.}

\item{wide}{Fitted model object containing the wide model.}
}
\description{
Given a model indicator \code{inds} identifying terms in a regression
model, convert this to the format needed for \code{\link{fic}} by converting
indicators for regression terms to indicators for inclusion of
parameters.  Only required if there are factors.
}
\details{
If a regression term is a factor, then the 0 or 1 indicating its
inclusion/exclusion is replicated to a length given by the number
of factor levels minus 1, that is, the number of parameters
pertaining to that factor.

This function only works for classes of models for which the
\code{model.matrix} function is understood and returns objects
with an \code{"assign"} attribute. This includes all the
commonly-used models in base R.
}
\examples{

# Five terms in this model: intercept and four covariates,
# but the covariate "ftv" is a factor with 3 levels,
# so there are six parameters
bwt.glm <- glm(low ~ lwtkg + age + smoke + ftv, data=birthwt, family="binomial")

## Convert indicator for terms to indicator for parameters 
inds <- rbind(c(1,1,1,0,0),
              c(1,1,1,1,1))
expand_inds(inds, bwt.glm)


}
