% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prot_read.R
\name{read_prot}
\alias{read_prot}
\title{Read Protein Surface File}
\arguments{
\item{file}{Path or name of protein surface file (.srf).}
}
\value{
A data frame with the following columns:
\describe{
\item{ATOM}{atomic contact identifiers}
\item{NUMBER_POINTS}{number of points (integer) on atomic surface}
\item{AREA}{surface area (numeric)}
\item{RAYLENGTH}{average ray length (numeric)}
\item{DISTANCE}{average distance of contacts (numeric)}
}
}
\description{
Reads and processes data from protein surface files generated by the 'occluded_surface' function. The results enable important analyses of protein behavior at the atomic level.
}
\details{
The function reads a surface file containing data calculated using the 'OS' or 'FIBOS' methodology. The file should be in the format generated by the 'occluded_surface' function.
}
\author{
Carlos Henrique da Silveira (carlos.silveira@unifei.edu.br)

Herson Hebert Mendes Soares (hersonhebert@hotmail.com)

Joao Paulo Roquim Romanelli (joaoromanelli@unifei.edu.br)

Patrick Fleming (Pat.Fleming@jhu.edu)
}
\keyword{internal}
