% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffmanova.R, R/unitest.R
\name{unitests}
\alias{unitests}
\alias{unitest}
\title{Univariate F or t testing}
\usage{
unitests(xyObj)

unitest(modelData, errorData, dfError = dim(errorData)[1])
}
\arguments{
\item{xyObj}{a design-with-responses object created by \code{\link{xy_Obj}}}

\item{modelData}{matrix of hypothesis observations}

\item{errorData}{matrix of error observations}

\item{dfError}{Degrees of freedom for error needs to be specified if
\code{errorData} is incomplete}
}
\value{
\code{unitest} returns a list with components
\item{pValues}{\eqn{p}-values} \item{stat}{The test statistics as
\eqn{t}-statistics (when single degree of freedom) or \eqn{F}-statistics }

\code{unitests} returns a list with components \item{pRaw}{Matrix of
\eqn{p}-values from \code{unitest}, one row for each term.}
\item{stat}{Matrix of test statistics from \code{unitest}, one row for each
term.}
}
\description{
The functions perform \eqn{F} or \eqn{t} testing for several responses based
on a matrix of hypothesis observations and a matrix of error observations.
}
\details{
\code{modelData} and \code{errorObs} correspond to \code{hypObs} and
\code{errorObs} calculated by \code{xy_Obj}. These matrices are efficient
representations of sums of squares and cross-products (see
\code{\link{xy_Obj}} for details).  This means the univariate
\eqn{F}-statistics can be calculated straightforwardly from these input
matrices. Furthermore, in the single-degree-of-freedom case,
\eqn{t}-statistics with correct sign can be obtained.

\code{unitests} is a wrapper function that calls \code{unitest} for each
term in the \code{xyObj} (see \code{\link{xy_Obj}} for details) and collects
the results.
}
\note{
The function calculates the \eqn{p}-values by making a call to
\code{pf}.
}
\seealso{
\code{\link{rotationtest}}, \code{\link{rotationtests}}
}
\author{
Øyvind Langsrud and Bjørn-Helge Mevik
}
\keyword{htest}
