% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bkg_clc.R
\name{bkg_clc}
\alias{bkg_clc}
\title{Corine Land Cover}
\usage{
bkg_clc(
  ...,
  year = "2018",
  bbox = NULL,
  poly = NULL,
  predicate = "intersects",
  filter = NULL,
  epsg = 3035,
  properties = NULL,
  max = NULL
)
}
\arguments{
\item{...}{Used to construct CQL filters. Dot arguments accept an R-like
syntax that is converted to CQL queries internally. These queries basically
consist of a property name on the left, an aribtrary vector on the right,
and an operator that links both sides. If multiple queries are provided,
they will be chained with \code{AND}. The following operators and their
respective equivalents in CQL and XML are supported:

\tabular{lll}{
\strong{R} \tab \strong{CQL} \tab \strong{XML}\cr
\code{==} \tab \code{=} \tab \code{PropertyIsEqualTo}\cr
\code{!=} \tab \code{<>} \tab \code{PropertyIsNotEqualTo}\cr
\code{<} \tab \code{<} \tab \code{PropertyIsLessThan}\cr
\code{>} \tab \code{>} \tab \code{PropertyIsGreaterThan}\cr
\code{>=} \tab \code{>=} \tab \code{PropertyIsGreaterThanOrEqualTo}\cr
\code{<=} \tab \code{<=} \tab \code{PropertyIsLessThanOrEqualTo}\cr
\code{\%LIKE\%} \tab \code{LIKE} \tab \code{PropertyIsLike}\cr
\code{\%ILIKE\%} \tab \code{ILIKE} \tab\cr
\code{\%in\%} \tab \code{IN} \tab \code{PropertyIsEqualTo} and \code{Or}
}

To construct more complex queries, you can use the \code{filter} argument
to pass CQL queries directly. Also note that you can switch between
CQL and XML queries using \code{options(ffm_query_language = "xml")}.
See also \code{\link{wfs_filter}}.}

\item{year}{Version year of the dataset. You can use \code{latest} to
retrieve the latest dataset version available on the BKG's geodata center.
Older versions can be browsed using the
\href{https://daten.gdz.bkg.bund.de/produkte/}{archive}.}

\item{bbox}{An sf geometry or a boundary box vector of the format
\code{c(xmin, ymin, xmax, ymax)}. Used as a geometric filter to include
only those geometries that relate to \code{bbox} according to the predicate
specified in \code{predicate}. If an sf geometry is provided, coordinates
are automatically transformed to ESPG:25832 (the default CRS), otherwise
they are expected to be in EPSG:25832.}

\item{poly}{An sf geometry. Used as a geometric filter to include
only those geometries that relate to \code{poly} according to the predicate
specified in \code{predicate}. Coordinates are automatically transformed to
ESPG:25832 (the default CRS).}

\item{predicate}{A spatial predicate that is used to relate the output
geometries with the object specified in \code{bbox} or \code{poly}. For
example, if \code{predicate = "within"}, and \code{bbox} is specified,
returns only those geometries that lie within \code{bbox}. Can be one of
\code{"equals"}, \code{"disjoint"}, \code{"intersects"}, \code{"touches"},
\code{"crosses"}, \code{"within"}, \code{"contains"}, \code{"overlaps"},
\code{"relate"}, \code{"dwithin"}, or \code{"beyond"}. Defaults to
\code{"intersects"}.}

\item{filter}{A character string containing a valid CQL or XML filter. This
string is appended to the query constructed through \code{...}. Use this
argument to construct more complex filters. Defaults to \code{NULL}.}

\item{epsg}{An EPSG code specifying a coordinate reference system of the
output. If you're unsure what this means, try running
\code{sf::st_crs(...)$epsg} on a spatial object that you are working with.
Defaults to 3035.}

\item{properties}{Vector of columns to include in the output.}

\item{max}{Maximum number of results to return.}
}
\value{
An sf dataframe with polygon geometries and the following columns:
\itemize{
\item{\code{clc*}: CLC land cover classes for the given year. An overview
of all CLC classes can be found in the
\href{https://land.copernicus.eu/content/corine-land-cover-nomenclature-guidelines/html/}{Copernicus documentation}}.
\item{\code{shape_length}: Circumference of the polygon in meters}
\item{\code{shape_area}: Area of the polygon in square meters}
}
}
\description{
Retrieve land cover polygons in Germany based on the Corine
Land Cover (CLC) nomenclature.
\href{https://land.copernicus.eu/en/products/corine-land-cover}{Corine Land Cover}
is a way to project by the European Commission to consistenly classify
both land cover and land use.

This function interfaces the \code{wfs_clc5_*} products of the BKG.
}
\section{Query language}{

By default, WFS requests use CQL (Contextual Query Language) queries for
simplicity. CQL queries only work together with GET requests. This means
that when the URL is longer than 2048 characters, they fail.
While POST requests are much more flexible and able to accommodate long
queries, XML is really a pain to work with and I'm not confident in my
approach to construct XML queries. You can control whether to send GET or
POST requests by setting \code{options(ffm_query_language = "XML")}
or \code{options(ffm_query_language = "CQL")}.
}

\examples{
\dontshow{if (getFromNamespace("ffm_run_examples", ns = "ffm")()) withAutoprint(\{ # examplesIf}
# Get glaciers in Germany
bkg_clc(clc18 == "335")

# Get all coastal wetlands
bkg_clc(clc18 \%LIKE\% "42\%")

# Get only wetlands in Lower Saxony
lowsax <- bkg_admin(level = "lan", scale = "5000", sn_l == "03", gf == 9)
wetlands <- bkg_clc(clc18 \%LIKE\% "4\%", poly = lowsax, lang = "xml")
plot(lowsax$geometry)
plot(wetlands$geometry, add = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://sgx.geodatenzentrum.de/web_public/gdz/dokumentation/deu/clc5_2018.pdf}{\code{wfs_clc5_2018} documentation}

\href{https://mis.bkg.bund.de/trefferanzeige?docuuid=EC1C7EAE-BA08-4006-AC69-20E1C8200E64}{\code{wfs_clc5_2018} MIS record}
}
