% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fence.lmer.R
\name{fence.lmer}
\alias{fence.lmer}
\title{Fence model selection (Linear Mixed Model)}
\usage{
fence.lmer(full, data, B = 100, grid = 101, fence = c("adaptive",
  "nonadaptive"), cn = NA, REML = TRUE, bandwidth = NA,
  cpus = parallel::detectCores())
}
\arguments{
\item{full}{formula of full model}

\item{data}{data}

\item{B}{number of bootstrap samples, parametric bootstrap is used}

\item{grid}{grid for c}

\item{fence}{a procedure of the fence method to be used.
It's suggested to choose nonadaptive procedure if c is known; otherwise nonadaptive must be chosen}

\item{cn}{cn value for nonadaptive}

\item{REML}{Restricted Maximum Likelihood approach}

\item{bandwidth}{bandwidth for kernel smooth function}

\item{cpus}{Number of parallel computers}
}
\value{
\item{models}{list all model candidates in the model space}
\item{B}{list the number of bootstrap samples that have been used}
\item{lack_of_fit_matrix}{list a matrix of Qs for all model candidates (in columns). Each row is for each bootstrap sample}
\item{Qd_matrix}{list a matrix of QM - QM.tilde for all model candidates. Each row is for each bootrap sample}
\item{bandwidth}{list the value of bandwidth}
\item{model_mat}{list a matrix of selected models at each c values in grid (in columns). Each row is for each bootstrap sample}
\item{freq_mat}{list a matrix of coverage probabilities (frequency/smooth_frequency) of each selected models for a given c value (index)}
\item{c}{list the adaptive choice of c value from which the parsimonious model is selected}
\item{sel_model}{list the selected (parsimonious) model given the adaptive c value}
 @note The current Fence package focuses on variable selection. 
 However, Fence methods can be used to select other parameters of interest, e.g., tunning parameter, variance-covariance structure, etc.
}
\description{
Fence model selection (Linear Mixed Model)
}
\details{
In Jiang et. al (2008), the adaptive c value is chosen from the highest peak in the p* vs. c plot.  
In Jiang et. al (2009), 95\% CI is taken into account while choosing such an adaptive choice of c.
In Thuan Nguyen et. al (2014), the adaptive c value is chosen from the first peak. This approach works better in the 
moderate sample size or weak signal situations.  Empirically, the first peak becomes highest peak when sample size 
increases or signals become stronger
}
\examples{
require(fence)
library(snow)

#### Example 1 #####
data(iris)
full = Sepal.Length ~ Sepal.Width + Petal.Length + Petal.Width + (1|Species)
# Takes greater than 5 seconds to run
# test_af = fence.lmer(full, iris)
# test_af$c
# test_naf = fence.lmer(full, iris, fence = "nonadaptive", cn = 12)
# plot(test_af)
# test_af$sel_model
# test_naf$sel_model
}
\references{
\itemize{
 \item{Jiang J., Rao J.S., Gu Z., Nguyen T. (2008),  Fence Methods for Mixed Model Selection. The Annals of Statistics, 36(4): 1669-1692}
 \item{Jiang J., Nguyen T., Rao J.S. (2009), A Simplified Adaptive Fence Procedure. Statistics and Probability Letters, 79, 625-629}
 \item{Thuan Nguyen, Jie Peng, Jiming Jiang (2014), Fence Methods for Backcross Experiments.  Statistical Computation and Simulation, 84(3), 644-662}
}
}
\author{
Jiming Jiang  Jianyang Zhao  J. Sunil Rao  Thuan Nguyen
}
