% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfee_pois.R
\name{dfee_pois}
\alias{dfee_pois}
\title{Marginal First-Exposure Effects for One-Inflated Poisson Model}
\usage{
dfee_pois(b, g, X, Z, dummies)
}
\arguments{
\item{b}{A numeric vector of estimated coefficients for the rate.}

\item{g}{A numeric vector of estimated coefficients for inflation.}

\item{X}{A numeric matrix of covariates for the rate.}

\item{Z}{A numeric matrix of covariates for inflation.}

\item{dummies}{A character vector naming the binary (dummy) variables to compute marginal effects for.}
}
\value{
A matrix of marginal first-exposure effects. Each column corresponds
to a covariate, and each row corresponds to an observation in the data.
}
\description{
This function is used internally by \code{\link{dfee}}. The function computes
analytical derivatives of the FEE with respect to covariates, and uses discrete
differences for binary indicators.
}
\seealso{
\code{\link{dfee}}, \code{\link{fee_pois}}, \code{\link{dfee_nb}}
}
\keyword{internal}
