mtcars.f <- feather(feather_example("mtcars.feather"))
iris.f <- feather(feather_example("iris.feather"))

test_that("basic access", {
  expect_equal(nrow(mtcars.f), nrow(mtcars))
  expect_equal(ncol(mtcars.f), ncol(mtcars))
  expect_equal(dim(mtcars.f), dim(mtcars))
  expect_equal(dimnames(iris.f), dimnames(iris))
  expect_equal(colnames(iris.f), colnames(iris))
  expect_equal(names(iris.f), names(iris))
  expect_equal(as.data.frame(iris.f[1:5, 1:5]), iris[1:5, 1:5])
  expect_equal(as.data.frame(iris.f[, 1:5]), iris[, 1:5])
  expect_equal(as.data.frame(iris.f[1:5, ]), iris[1:5, ])
  expect_equal(as.data.frame(iris.f[1:5]), iris[1:5])
  expect_equal(as.data.frame(iris.f[]), iris[])
  expect_equal(as.vector(iris.f[["Species"]]), iris[["Species"]])
  expect_equal(as.vector(iris.f[["Sepal.Length"]]), iris[["Sepal.Length"]])
  expect_equal(as.vector(iris.f$Species), iris$Species)
  expect_equal(as.vector(iris.f$Sepal.Width), iris$Sepal.Width)
})

test_that("coercion", {
  expect_identical(tibble::as_tibble(iris.f), tibble::as_tibble(iris))
  expect_identical(as.data.frame(iris.f), iris)
  expect_identical(as.list(iris.f), as.list(iris))
})
