#' fdapace: Functional Data Analysis and Empirical Dynamics
#' 
#' fdapace is a versatile package that provides implementation of various methods
#' of Functional Data Analysis (FDA) and Empirical Dynamics. The core of this
#' package is Functional Principal Component Analysis (FPCA), a key technique
#' for functional data analysis, for sparsely or densely sampled random
#' trajectories and time courses, via the Principal Analysis by Conditional
#' Estimation (PACE) algorithm. This core algorithm yields covariance and mean 
#' functions, eigenfunctions and principal component (scores), for both functional 
#' data and derivatives, for both dense (functional) and sparse (longitudinal) 
#' sampling designs. For sparse designs, it provides fitted continuous 
#' trajectories with confidence bands, even for subjects with very few longitudinal 
#' observations. PACE is a viable and flexible alternative to random effects modeling
#' of longitudinal data. There is also a Matlab version (PACE) that contains some 
#' methods not available on fdapace and vice versa.
#'
#' Links for fdapace/PACE:
#' Matlab version of pace at http://anson.ucdavis.edu/~mueller/data/pace.html
#' Papers and background at http://anson.ucdavis.edu/~mueller/  and  http://www.stat.ucdavis.edu/~wang/
#' 
#' PACE is based on the idea that observed functional data are generated by a 
#' sample of underlying (but usually not fully observed) random trajectories 
#' that are realizations of a stochastic process. It does not rely on pre-smoothing 
#' of trajectories, which is problematic if functional data are sparsely sampled.
#' 
#' The functional principal components can be used for further statistical analysis 
#' depending on the demands of a user, for example if one has densely sampled 
#' functional predictors and a generalized response, such as in a GLM, the predictor 
#' functions can be replaced by their first couple of principal component scores that
#' will then be used as predictors; one can also easily fit polynomial functional 
#' models by using powers (usually squares) and interactions of functional principal 
#' components among the predictors for a scalar response. 
#' 
#' fdapace is a comprehensive package that directly implements fitting of the following models:
#' \itemize{
#' \item functional linear regression 
#' \item functional additive regression
#' \item functional covariance and correlation (via dynamic correlation) 
#' \item functional clustering 
#' \item concurrent (varying coefficient) regression models for sparse and dense designs
#' \item varying coefficient additive models
#' \item multivariate functional data analysis (normalization and functional singular component analysis)
#' \item variance processes and volatility processes (the latter of interest in finance)
#' \item optimal designs for longitudinal data analysis (for trajectory prediction and for functional linear regression) 
#' \item stringing, a method to convert high-dimensional data into functional data
#' \item quantile regression, with functions as predictors
#' }
#' 
#' @references
#' \itemize{
#' \item Wang, J.L., Chiou, J.,  Müller, H.G. (2016). Functional data analysis. Annual Review of Statistics and Its Application 3, 257--295;
#' \item Chen, K., Zhang, X., Petersen, A., Müller, H.G.  (2017). Quantifying infinite-dimensional data: Functional Data Analysis in action. Statistics in Biosciences 9, 582–-604.
#' }
#' 
#' @author
#' \strong{Maintainer}: Yidong Zhou \email{ydzhou@ucdavis.edu} (\href{https://orcid.org/0000-0003-1423-1857}{ORCID})
#' 
#' Authors:
#' \itemize{
#' \item Han Chen
#' \item Su I Iao
#' \item Poorbita Kundu
#' \item Hang Zhou
#' \item Satarupa Bhattacharjee
#' \item Cody Carroll (\href{https://orcid.org/0000-0003-3525-8653}{ORCID})
#' \item Yaqing Chen
#' \item Xiongtao Dai
#' \item Jianing Fan
#' \item Alvaro Gajardo
#' \item Pantelis Z. Hadjipantelis
#' \item Kyunghee Han
#' \item Hao Ji
#' \item Changbo Zhu
#' \item Hans-Georg Müller \email{hgmueller@ucdavis.edu} [copyright holder, thesis advisor]
#' \item Jane-Ling Wang \email{janelwang@ucdavis.edu} [copyright holder, thesis advisor]
#' }
#' 
#' Other contributors:
#' \itemize{
#' \item Paromita Dubey [contributor]
#' \item Shu-Chin Lin [contributor]
#' }
#' 
#' @seealso
#' Useful links:
#' \itemize{
#' \item \url{https://github.com/functionaldata/tPACE}
#' \item Report bugs at \url{https://github.com/functionaldata/tPACE/issues}
#' }
#' 
#' _PACKAGE
#' @name fdapace
#' @useDynLib fdapace
#' @import Rcpp
#' @importFrom Matrix Matrix
#' @importFrom Hmisc approxExtrap
#' @importFrom pracma meshgrid midpoint mod ones uniq
#' @importFrom numDeriv grad hessian
#' @importFrom grDevices colorRampPalette dev.new palette
#' @importFrom graphics abline barplot boxplot grid legend lines matlines matplot par plot points polygon 
#' @importFrom stats aggregate approx approxfun binomial cov dist fitted glm kmeans lm median na.omit optim predict quantile rnorm runif spline var sd poly weighted.mean cor dunif
#' @importFrom utils head tail
#' @importFrom MASS isoMDS mvrnorm
NULL
