% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FEMobjects.R
\name{FEM.time}
\alias{FEM.time}
\title{Define a spatio-temporal field by a Finite Element basis expansion}
\usage{
FEM.time(coeff,time_mesh,FEMbasis,FLAG_PARABOLIC=FALSE)
}
\arguments{
\item{coeff}{A vector or a matrix containing the coefficients for the spatio-temporal basis expansion. The number of rows
(or the vector's length) corresponds to the number of basis in \code{FEMbasis} times the number of knots in \code{time_mesh}.}

\item{time_mesh}{A vector containing the b-splines knots for separable smoothing and the nodes for finite differences for parabolic smoothing}

\item{FEMbasis}{A \code{FEMbasis} object defining the Finite Element basis, created by \link{create.FEM.basis}.}

\item{FLAG_PARABOLIC}{Boolean. If \code{TRUE} the coefficients are from parabolic smoothing, if \code{FALSE} the separable one.}
}
\value{
A \code{FEM.time} object. This contains a list with components \code{coeff}, \code{mesh_time}, \code{FEMbasis} and \code{FLAG_PARABOLIC}.
}
\description{
This function defines a FEM.time object.
}
\examples{
library(fdaPDE)
## Upload the horseshoe2D data
data(horseshoe2D)

## Create the 2D mesh
mesh = create.mesh.2D(nodes = rbind(horseshoe2D$boundary_nodes, horseshoe2D$locations), 
                      segments = horseshoe2D$boundary_segments)
## Create the FEM basis
FEMbasis = create.FEM.basis(mesh)
## Compute the coeff vector evaluating the desired function at the mesh nodes
## In this case we consider the fs.test() function introduced by Wood et al. 2008
coeff = rep(fs.test(mesh$nodes[,1], mesh$nodes[,2]),5)
time_mesh = seq(0,1,length.out = 5)
## Create the FEM object
FEMfunction = FEM.time(coeff, time_mesh, FEMbasis, FLAG_PARABOLIC = TRUE)
## Plot it at desired time
plot(FEMfunction,0.7)
}
