% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{process_data}
\alias{process_data}
\title{Process FCA Call Report data in a specified folder}
\usage{
process_data(dir)
}
\arguments{
\item{dir}{(String) The path to a folder containing FCA Call Report .TXT
files for a single quarter}
}
\value{
A list containing processed data and metadata.
}
\description{
\code{process_data()} reads the downloaded (and unzipped) .TXT files into tidy
data frames, applying the schema from the "D_" files to the corresponding raw
comma-separated data files, as well as storing the metadata from the "D_"
files
}
\details{
\code{process_data()} assumes that metadata and data files share a common root
name (characters until the first underscore occurrence).
}
\examples{
\donttest{

  path <- tempfile("fcadata")
  dir.create(path)

  download_data(
    year = 2025,
    month = "September",
    dest = path
  )

  processed_data <- process_data(path)

  # Access "RCB" data
  processed_data$data$RCB

  # Access "RCB" metadata
  processed_data$metadata$RCB
}
}
