% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbroc.paired.methods.R
\name{extract.roc}
\alias{extract.roc}
\title{Extracts one from two paired ROC curves from a \code{fbroc.paired.roc} object}
\usage{
extract.roc(x, index)
}
\arguments{
\item{x}{Object of class \code{fbroc.paired.roc}.}

\item{index}{A number specifying which of the two ROC curves should be returned. Needs to be 1 or 2.}
}
\value{
An object of class \code{fbroc.roc} containing all data about the requested ROC curve
}
\description{
Given paired ROC curves it can be helpful to look at them in isolation as well. 
This functions allows the extraction of one of the paired ROC
curves as a \code{fbroc.roc} object without recalculating the ROC curve.
}
\section{Note}{


Due to the way the predictions are reordered internally, using use.cache to save the bootstrap
results for paired ROC curves and then extracting one of the two curves will not yield the same
values as when the ROC curve is bootstrapped as a single curve using \code{fbroc.roc}.
}

\examples{
data(roc.examples)
example <- boot.paired.roc(roc.examples$Cont.Pred, roc.examples$Cont.Pred.Outlier, 
                           roc.examples$True.Class, n.boot = 100)
roc1 <- extract.roc(example, 1)
roc1.equivalent <- boot.roc(roc.examples$Cont.Pred, roc.examples$True.Class, 
                            n.boot = 100)
print(identical(roc1, roc1.equivalent)) # roc1 and roc1.equivalent will be the same
# This does not hold when use.cache = TRUE. See the note above.
}
\seealso{
\code{\link{boot.paired.roc}}
}
