% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fb_creative.R
\name{fbad_create_creative}
\alias{fbad_create_creative}
\title{Create an ad creative}
\usage{
fbad_create_creative(
  fbacc,
  title,
  body,
  name,
  actor_id,
  follow_redirect,
  image_file,
  image_hash,
  image_crops,
  image_url,
  link_url,
  url_tags,
  object_id,
  object_story_id,
  object_story_spec,
  object_url,
  call_to_action_type = c("OPEN_LINK", "BOOK_TRAVEL", "SHOP_NOW", "PLAY_GAME",
    "LISTEN_MUSIC", "WATCH_VIDEO", "USE_APP")
)
}
\arguments{
\item{fbacc}{(optional) \code{FB_Ad_account} object, which defaults to the last returned object of \code{\link{fbad_init}}.}

\item{title}{string}

\item{body}{string}

\item{name}{string}

\item{actor_id}{Facebook object ID reference}

\item{follow_redirect}{boolean}

\item{image_file}{local image passed to Facebook. You might first upload the image via \code{fbad_create_image}.}

\item{image_hash}{string}

\item{image_crops}{list}

\item{image_url}{string}

\item{link_url}{string}

\item{url_tags}{list}

\item{object_id}{Facebook object ID reference}

\item{object_story_id}{post ID reference}

\item{object_story_spec}{list}

\item{object_url}{string list}

\item{call_to_action_type}{string}
}
\value{
creative id
}
\description{
Create an ad creative
}
\note{
There are no checks done before passing provided arguments to Facebook. You have to know what you are up to. Read the Facebook docs.
}
\references{
\url{https://developers.facebook.com/docs/marketing-api/reference/ad-creative#Creating}
}
