% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fb_insights.R
\name{fb_insights}
\alias{fb_insights}
\title{Insights}
\usage{
fb_insights(
  fbacc,
  target = fbacc$acct_path,
  job_type = c("sync", "async"),
  retries = 0,
  simplify = TRUE,
  ...
)
}
\arguments{
\item{fbacc}{(optional) \code{FB_Ad_account} object, which defaults to the last returned object of \code{\link{fbad_init}}.}

\item{target}{ad account id(s) (default), campaign id(s), adset id(s) or ad id(s)}

\item{job_type}{synchronous or asynchronous request. If the prior fails with "please reduce the amount of data", it will fall back to async request. Async query is possible with only one target.}

\item{retries}{number of times this query has been sent to Facebook previously and failed -- to be used internally for error handling}

\item{simplify}{return a list of \code{data.frame} or \code{list} objects}

\item{...}{named arguments passed to the API, like time range, fields, filtering etc.}
}
\value{
\code{list} of \code{data.frame} or \code{list} objects depending on the \code{simplify} argument
}
\description{
Insights
}
\examples{
\dontrun{
fb_insights(fbacc)

## get default fields and filter for a few metrics
l <- fb_insights(date_preset = 'today', level = 'ad')
## merge pages into tabular data
data.table::rbindlist(l)

## sometimes more advanced list selections are needed
l <- fb_insights(date_preset = 'today', level = 'ad', fields = 'unique_actions', simplify = FALSE)

## filter for ACTIVE Ads
l <- fb_insights(date_preset = 'today', level = 'ad',
  filtering = "[{'field':'adset.effective_status','operator':'IN','value':['ACTIVE']}]")
}
}
\references{
\url{https://developers.facebook.com/docs/marketing-api/insights}
}
