% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fauna_data}
\alias{fauna_data}
\title{Catálogo Taxonômico da Fauna do Brasil database - Version 1.17}
\format{
A \code{data.frame} with 9558 rows and 19 variables:
\describe{
\item{species}{Species names}
\item{subspecies}{Subspecies names}
\item{scientificName}{Complete scientific name of the species}
\item{validName}{Valid name of the species (NA when the name in
species is already a valid name)}
\item{kingdom}{Kingdom to which species belongs (Animalia)}
\item{phylum}{Phylum to which species belongs}
\item{class}{Class to which species belongs}
\item{order}{Order to which species belongs}
\item{family}{Family to which species belongs}
\item{genus}{Genus to which species belongs}
\item{lifeForm}{Life form of the species (e.g: free_living_individual,
colonial, sessile, etc.)}
\item{habitat}{Habitat type of the species (e.g., terrestrial, arboreal,
freshwater, etc.)}
\item{states}{Federal states with confirmed occurrences of the species}
\item{countryCode}{Countries with confirmed occurrences of the species}
\item{origin}{Indicates whether the species is native, introduced,
domesticated, cryptogenic or invasive}
\item{taxonomicStatus}{Indicates the level of recognition and acceptance
of the species (valid or synonym)}
\item{nomenclaturalStatus}{Indicates the legitimacy and validity of the
species name (original_combination, changed_combination, etc.)}
\item{vernacularName}{Locally or culturally used name for the species}
\item{taxonRank}{Taxonomic rank (Species, Genus, Family, Order, etc). This
data contains only Species}
}
}
\usage{
data(fauna_data)
}
\description{
A dataset containing a subset of the Catálogo Taxonômico da Fauna do Brasil
database (version 1.17)
}
\references{
Brazilian Zoology Group. Catálogo Taxonômico da Fauna do Brasil. Available at:
https://ipt.jbrj.gov.br/jbrj/resource?r=catalogo_taxonomico_da_fauna_do_brasil
}
\keyword{datasets}
