% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgboost_survival.R
\name{predict_risk}
\alias{predict_risk}
\alias{predict_risk.fastml_native_survival}
\alias{predict_risk.workflow}
\alias{predict_risk.default}
\title{Predict Risk Scores from a Survival Model}
\usage{
predict_risk(fit, newdata, ...)

\method{predict_risk}{fastml_native_survival}(fit, newdata, ...)

\method{predict_risk}{workflow}(fit, newdata, ...)

\method{predict_risk}{default}(fit, newdata, ...)
}
\arguments{
\item{fit}{A fitted survival model object.}

\item{newdata}{A data frame containing predictor variables for which to
compute risk scores.}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
A numeric vector of risk scores, where higher values indicate
greater predicted risk.
}
\description{
Provides a consistent interface for computing linear predictors (risk scores)
across various survival modeling engines, including native \pkg{fastml} models
(e.g., Cox proportional hazards, XGBoost Cox) and \pkg{parsnip}/workflow objects.
}
\keyword{internal}
