% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{compare_fits}
\alias{compare_fits}
\title{Summarize and Compare Model Fits}
\usage{
compare_fits(fits)
}
\arguments{
\item{fits}{An object of class \code{"poisson_nmf_fit"} or
\code{"multinom_topic_model_fit"}, or a non-empty, named list in
which all list elements are Poisson NMF model fits or all
multinomial topic model fits.}
}
\value{
A data frame with one row per element of \code{fits}, and
with the following columns:

\item{k}{The rank of the matrix factorization.}

\item{loglik}{The log-likelihood (either Poisson NMF or multinomial topic
  model likelihood) achieved at the last model fitting update.}

\item{dev}{For Poisson NMF model fits only, the deviance achieved
  at the last model fitting update.}

\item{res}{The maximum residual of the Karush-Kuhn-Tucker (KKT)
  system achieved at the last model fitting update; small values
  indicate that the solution is close to a local maximum, or
  stationary point, of the likelihood.}

\item{loglik.diff}{The improvement in the log-likelihood relative
  to the model fit with the smallest log-likelihood.}

\item{dev.diff}{The improvement in the deviance relative to the
  model fit with the largest deviance.}

\item{nonzeros.f}{The rate of nonzeros in the factors matrix, as
  determined by \code{control$zero.threshold}.}

\item{nonzeros.l}{The rate of nonzeros in the loadings matrix, as
  determined by \code{control$zero.threshold}.}

\item{numiter}{The number of loadings and/or factor updates
  performed.}

\item{runtime}{The total runtime (in s) of the model fitting
  updates.}
}
\description{
Create a table summarizing the results of fitting one
  or more Poisson non-negative matrix factorizations or multinomial
  topic models.
}
\seealso{
\code{\link{fit_poisson_nmf}},
  \code{\link{fit_topic_model}}
}
