% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rupdate}
\alias{rupdate}
\title{Fast updating of the R matrix}
\arguments{
\item{X}{the current \eqn{n\times p} matrix, prior to the addition of any rows or columns.}

\item{R}{a \eqn{p\times p} upper triangular matrix.}

\item{U}{either a \eqn{n\times m} matrix or a \eqn{p\times m} matrix of columns or rows to be added.}

\item{type}{either 'row' of 'column', for adding rows or columns.}

\item{fast}{fast mode: disable to check whether the provided matrices are valid inputs. Default is FALSE.}
}
\value{
R the updated R matrix.
}
\description{
updates the R factorization when \eqn{m \geq 1} rows or columns are added to the matrix \eqn{X \in \mathbb{R}^{n \times p}}, where \eqn{n > p}. The R factorization of \eqn{X} produces an upper triangular matrix \eqn{R \in \mathbb{R}^{p \times p}} such that \eqn{X^\top X = R^\top R}. For more details on this method, refer to Golub and Van Loan (2013). Columns can only be added in positions \eqn{p+1} through \eqn{p+m}, while the position of added rows does not need to be specified.
}
\examples{
## Add one column
## generate sample data
set.seed(1234)
n <- 12
p <- 5
X <- matrix(rnorm(n * p, 1), n, p)

## get the initial QR factorization
output <- fastQR::qr(X, complete = TRUE)
Q      <- output$Q
R      <- output$R
R1     <- R[1:p,]

## create column to be added
u  <- matrix(rnorm(n), n, 1)
X1 <- cbind(X, u)

## update the R decomposition
R2 <- fastQR::rupdate(X = X, R = R1, U = u,
                      fast = FALSE, type = "column")

## check
max(abs(crossprod(R2) - crossprod(X1)))

## Add m columns
## generate sample data
set.seed(1234)
n <- 10
p <- 5
X <- matrix(rnorm(n * p, 1), n, p)

## get the initial QR factorization
output <- fastQR::qr(X, complete = TRUE)
Q      <- output$Q
R      <- output$R
R1     <- R[1:p,]

## create the matrix of columns to be added
m  <- 2
U  <- matrix(rnorm(n*m), n, m)
X1 <- cbind(X, U)

# QR update
R2 <- fastQR::rupdate(X = X, R = R1, U = U,
                      fast = FALSE, type = "column")

## check
max(abs(crossprod(R2) - crossprod(X1)))

## Add one row
## generate sample data
set.seed(1234)
n <- 12
p <- 5
X <- matrix(rnorm(n * p, 1), n, p)

## get the initial QR factorization
output <- fastQR::qr(X, complete = TRUE)
Q      <- output$Q
R      <- output$R
R1     <- R[1:p,]

## create the row u to be added
u  <- matrix(data = rnorm(p), p, 1)
k  <- 5
if (k<=n) {
  X1 <- rbind(rbind(X[1:(k-1), ], t(u)), X[k:n, ])
} else {
  X1 <- rbind(rbind(X, t(u)))
}

## update the R decomposition
R2 <- fastQR::rupdate(R = R1, X = X,
                      U = u,
                      type = "row")

## check
max(abs(crossprod(R2) - crossprod(X1)))

## Add m rows
## generate sample data
set.seed(1234)
n <- 12
p <- 5
X <- matrix(rnorm(n * p, 1), n, p)

## get the initial QR factorization
output <- fastQR::qr(X, complete = TRUE)
Q      <- output$Q
R      <- output$R
R1     <- R[1:p,]

## create the matrix of rows to be added
m  <- 2
U  <- matrix(data = rnorm(p*m), p, m)
k  <- 5
if (k<=n) {
  X1 <- rbind(rbind(X[1:(k-1), ], t(U)), X[k:n, ])
} else {
  X1 <- rbind(rbind(X, t(U)))
}

## update the R decomposition
R2 <- fastQR::rupdate(R = R1, X = X,
                      U = U,
                      fast = FALSE,
                      type = "row")

## check
max(abs(crossprod(R2) - crossprod(X1)))

}
\references{
\insertRef{golub_van_loan.2013}{fastQR}

\insertRef{bjorck.2015}{fastQR}

\insertRef{bjorck.2024}{fastQR}

\insertRef{bernardi_etal.2024}{fastQR}
}
