% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr_Q_full}
\alias{qr_Q_full}
\title{Reconstruct the full Q matrix from the qr object.}
\usage{
qr_Q_full(qr, tau)
}
\arguments{
\item{qr}{object representing a QR decomposition. This will typically have come from a previous call to qr.}

\item{tau}{a vector of length \eqn{ncol(X)} which contains additional information on \eqn{Q}. It corresponds to qraux from a previous call to qr.}
}
\value{
returns the matrix \eqn{Q\in\mathbb{R}^{n\times n}}.
}
\description{
returns the full \eqn{Q\in\mathbb{R}^{n\times n}} matrix.
}
\examples{
## create data: n > p
set.seed(1234)
n <- 12
p <- 7
X <- matrix(rnorm(n * p), n, p)

## get the full QR decomposition with pivot
qr_res <- fastQR::qr_fast(X = X,
                          tol = sqrt(.Machine$double.eps),
                          pivot = TRUE)

## complete the reduced Q matrix
Q <- fastQR::qr_Q_full(qr  = qr_res$qr,
                       tau = qr_res$qraux)

## check the Q matrix (orthogonality)
max(abs(crossprod(Q)-diag(1, n)))

}
\references{
\insertRef{golub_van_loan.2013}{fastQR}

\insertRef{bjorck.2015}{fastQR}

\insertRef{bjorck.2024}{fastQR}

\insertRef{bernardi_etal.2024}{fastQR}
}
