% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{residuals.FASSTER}
\alias{residuals.FASSTER}
\title{Extract residuals from a FASSTER model}
\usage{
\method{residuals}{FASSTER}(object, ...)
}
\arguments{
\item{object}{A fitted FASSTER model object.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A numeric vector of residuals with the same length as the training
data.
}
\description{
Returns the one-step-ahead forecast errors (residuals) from a FASSTER model.
}
\examples{
library(tsibble)
fit <- as_tsibble(mdeaths) |>
  model(FASSTER(value ~ trend(1) + fourier(12)))

# Extract residuals
residuals(fit)

}
