% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{components.FASSTER}
\alias{components.FASSTER}
\title{Extract Components from a FASSTER Model}
\usage{
\method{components}{FASSTER}(object, ...)
}
\arguments{
\item{object}{A FASSTER model object.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A dable (decomposition table) containing the response variable and
each model component as separate columns. The components sum to the
response variable.
}
\description{
Decomposes a FASSTER model into its individual components, allowing you to
examine the contribution of each term to the fitted values. This is useful
for understanding which components drive the model's predictions and how
well different aspects of the model fit the data.
}
\examples{
if (requireNamespace("tsibbledata", quietly = TRUE)) {
# Fit a FASSTER model and extract components
library(tsibble)
library(dplyr)
fit <- tsibbledata::aus_retail |>
  filter(
    State == "Victoria",
    Industry == "Cafes, restaurants and catering services"
  ) |>
  model(fasster = FASSTER(Turnover ~ trend(1) + season("year")))

# Extract and view components
components(fit)
}

}
