% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarDataComputationVimp.R
\name{export_fs_vimp}
\alias{export_fs_vimp}
\alias{export_fs_vimp,familiarCollection-method}
\alias{export_fs_vimp,ANY-method}
\title{Extract and export feature selection variable importance.}
\usage{
export_fs_vimp(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  aggregation_method = waiver(),
  rank_threshold = waiver(),
  export_collection = FALSE,
  ...
)

\S4method{export_fs_vimp}{familiarCollection}(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  aggregation_method = waiver(),
  rank_threshold = waiver(),
  export_collection = FALSE,
  ...
)

\S4method{export_fs_vimp}{ANY}(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  aggregation_method = waiver(),
  rank_threshold = waiver(),
  export_collection = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{familiarCollection} object, or other other objects from which
a \code{familiarCollection} can be extracted. See details for more information.}

\item{dir_path}{Path to folder where extracted data should be saved. \code{NULL}
will allow export as a structured list of data.tables.}

\item{aggregate_results}{Flag that signifies whether results should be
aggregated for export.}

\item{aggregation_method}{(\emph{optional}) The method used to aggregate variable
importances over different data subsets, e.g. bootstraps. The following
methods can be selected:
\itemize{
\item \code{mean} (default): Use the mean rank of a feature over the subsets to
determine the aggregated feature rank.
\item \code{median}: Use the median rank of a feature over the subsets to determine
the aggregated feature rank.
\item \code{best}: Use the best rank the feature obtained in any subset to determine
the aggregated feature rank.
\item \code{worst}: Use the worst rank the feature obtained in any subset to
determine the aggregated feature rank.
\item \code{stability}: Use the frequency of the feature being in the subset of
highly ranked features as measure for the aggregated feature rank
(Meinshausen and Buehlmann, 2010).
\item \code{exponential}: Use a rank-weighted frequence of occurrence in the subset
of highly ranked features as measure for the aggregated feature rank (Haury
et al., 2011).
\item \code{borda}: Use the borda count as measure for the aggregated feature rank
(Wald et al., 2012).
\item \code{enhanced_borda}: Use an occurrence frequency-weighted borda count as
measure for the aggregated feature rank (Wald et al., 2012).
\item \code{truncated_borda}: Use borda count computed only on features within the
subset of highly ranked features.
\item \code{enhanced_truncated_borda}: Apply both the enhanced borda method and the
truncated borda method and use the resulting borda count as the aggregated
feature rank.
}}

\item{rank_threshold}{(\emph{optional}) The threshold used to define the subset of
highly important features. If not set, this threshold is determined by
maximising the variance in the occurrence value over all features over the
subset size.

This parameter is only relevant for \code{stability}, \code{exponential},
\code{enhanced_borda}, \code{truncated_borda} and \code{enhanced_truncated_borda} methods.}

\item{export_collection}{(\emph{optional}) Exports the collection if TRUE.}

\item{...}{
  Arguments passed on to \code{\link[=as_familiar_collection]{as_familiar_collection}}
  \describe{
    \item{\code{familiar_data_names}}{Names of the dataset(s). Only used if the \code{object}
parameter is one or more \code{familiarData} objects.}
    \item{\code{collection_name}}{Name of the collection.}
  }}
}
\value{
A data.table (if \code{dir_path} is not provided), or nothing, as all data
is exported to \code{csv} files.
}
\description{
Extract and export feature selection variable importance from a
familiarCollection.
}
\details{
Data, such as model performance and calibration information, is
usually collected from a \code{familiarCollection} object. However, you can also
provide one or more \code{familiarData} objects, that will be internally
converted to a \code{familiarCollection} object. Paths to the previous files can
also be provided.

Unlike other export function, export using \code{familiarEnsemble} or
\code{familiarModel} objects is not possible. This is because feature selection
variable importance is not stored within \code{familiarModel} objects.

All parameters aside from \code{object} and \code{dir_path} are only used if \code{object}
is not a \code{familiarCollection} object, or a path to one.

Variable importance is based on the ranking produced by feature selection
routines. In case feature selection was performed repeatedly, e.g. using
bootstraps, feature ranks are first aggregated using the method defined by
the \code{aggregation_method}, some of which require a \code{rank_threshold} to
indicate a subset of most important features.

Information concerning highly similar features that form clusters is
provided as well. This information is based on consensus clustering of the
features. This clustering information is also used during aggregation to
ensure that co-clustered features are only taken into account once.
}
