% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.ffm.R
\name{summary.ffm}
\alias{summary.ffm}
\alias{print.summary.ffm}
\title{Summarizing a fitted fundamental factor model}
\usage{
\method{summary}{ffm}(object, ...)

\method{print}{summary.ffm}(x, digits = 3, labels = TRUE, ...)
}
\arguments{
\item{object}{an object of class \code{ffm} returned by \code{fitFfm}.}

\item{...}{futher arguments passed to or from other methods.}

\item{x}{an object of class \code{summary.ffm}.}

\item{digits}{number of significant digits to use when printing. 
Default is 3.}

\item{labels}{option to print labels and legend in the summary. Default is 
\code{TRUE}. When \code{FALSE}, only the coefficient matrx with standard 
errors is printed.}
}
\value{
Returns an object of class \code{summary.ffm}. 
The print method for class \code{summary.ffm} outputs the call, 
coefficients (with standard errors and t-statistics), r-squared and 
residual volatilty (under the homoskedasticity assumption) for all assets. 

Object of class \code{summary.ffm} is a list of length N + 2 containing:
\item{call}{the function call to \code{fitFfm}}
\item{sum.list}{list of summaries of the T fit objects (of class \code{lm} or 
\code{lmRob}) for each time period in the factor model.}
}
\description{
\code{summary} method for object of class \code{ffm}. 
Returned object is of class {summary.ffm}.
}
\details{
The default \code{summary} method for a fitted \code{lm} object 
computes the standard errors and t-statistics under the assumption of 
homoscedasticity.

Note: This gives a summary of the fitted factor returns at each time period. 
If \code{T} is large, you might prefer the more succinct summary produced by 
\code{\link{print.ffm}}.
}
\seealso{
\code{\link{fitFfm}}, \code{\link[stats]{summary.lm}}
}
\author{
Sangeetha Srinivasan & Yi-An Chen.
}
