% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmCov.R
\name{fmCov}
\alias{fmCov}
\alias{fmCov.ffm}
\title{Covariance Matrix for assets' returns from fitted factor model.}
\usage{
fmCov(object, factor.cov, ...)

\method{fmCov}{ffm}(object, factor.cov, use = "pairwise.complete.obs", ...)
}
\arguments{
\item{object}{fit object of class \code{tsfm}, \code{sfm} or \code{ffm}.}

\item{factor.cov}{factor covariance matrix (optional); defaults to the 
sample covariance matrix.}

\item{...}{optional arguments passed to \code{\link[stats]{cov}}.}

\item{use}{method for computing covariances in the presence of missing 
values; one of "everything", "all.obs", "complete.obs", "na.or.complete", or 
"pairwise.complete.obs". Default is "pairwise.complete.obs".}
}
\value{
The computed \code{N x N} covariance matrix for asset returns based 
on the fitted factor model.
}
\description{
Computes the covariance matrix for assets' returns based on a 
fitted factor model. This is a generic function with methods for classes 
\code{tsfm}, \code{sfm} and \code{ffm}.
}
\details{
\code{R(i, t)}, the return on asset \code{i} at time \code{t}, 
is assumed to follow a factor model of the form, \cr \cr 
\code{R(i,t) = alpha(i) + beta(i)*f(t) + e(i,t)}, \cr \cr  
where, \code{alpha(i)} is the intercept, \code{f(t)} is a {K x 1} vector of 
factor returns at time \code{t}, \code{beta(i)} is a \code{1 x K} vector of 
factor exposures and the error terms \code{e(i,t)} are serially 
uncorrelated across time and contemporaneously uncorrelated across assets 
so that \code{e(i,t) ~ iid(0,sig(i)^2)}. Thus, the variance of asset 
\code{i}'s return is given by \cr \cr
\code{var(R(i)) = beta(i)*cov(F)*tr(beta(i)) + sig(i)^2}. \cr \cr
And, the \code{N x N} covariance matrix of asset returns is \cr \cr
\code{var(R) = B*cov(F)*tr(B) + D}, \cr \cr 
where, B is the \code{N x K} matrix of factor betas and \code{D} is a 
diagonal matrix with \code{sig(i)^2} along the diagonal.

The method for computing covariance can be specified via the \dots 
argument. Note that the default of \code{use="pairwise.complete.obs"} for 
handling NAs restricts the method to "pearson".
}
\references{
Zivot, E., & Jia-hui, W. A. N. G. (2006). Modeling Financial Time 
Series with S-Plus Springer-Verlag.
}
\seealso{
\code{\link{fitFfm}}

\code{\link[stats]{cov}} for more details on arguments \code{use} and 
\code{method}.
}
\author{
Eric Zivot, Yi-An Chen and Sangeetha Srinivasan.
}
